using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace FS28BluetoothSlaveModeDemo
{
    public partial class FormTemplateList : Form
    {
        private string[] m_pSelectedTemplateFiles = null;
        private string m_strDbFolder;

        public FormTemplateList()
        {
            InitializeComponent();
        }

        public string[] SelectedTemplateFiles
        {
            get { return m_pSelectedTemplateFiles; }
        }

        private void FormTemplateList_Load(object sender, EventArgs e)
        {
            string[] subdirectoryEntries = Directory.GetDirectories(Directory.GetCurrentDirectory());
            string folderName;
            foreach (string subdirectory in subdirectoryEntries)
            {
                int nIndex = subdirectory.LastIndexOf("\\");
                folderName = subdirectory.Substring(nIndex + 1);
                listDbFolder.Items.Add(folderName);
            }
            if (listDbFolder.Items.Count == 0)
            {
                MessageBox.Show("There is not template!", "Database is empty", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                btnOK.Enabled = false;
            }
        }

        private void listDbFolder_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listDbFolder.SelectedIndex != -1)
            {
                listTemplateFiles.Items.Clear();
                m_strDbFolder = Path.Combine(Directory.GetCurrentDirectory(), listDbFolder.SelectedItem.ToString());
                string[] fileEntries = Directory.GetFiles(m_strDbFolder);
                foreach (string fileName in fileEntries)
                {
                    int nIndex = fileName.LastIndexOf("\\");
                    string simpleFileName = fileName.Substring(nIndex + 1);
                    listTemplateFiles.Items.Add(simpleFileName);
                }   
            }
        }

        private void btnSelectAll_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < listTemplateFiles.Items.Count; i++)
                listTemplateFiles.SelectedIndex = i;
            listTemplateFiles.Focus();
        }

        private void btnDeselectAll_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < listTemplateFiles.Items.Count; i++)
                listTemplateFiles.SelectedIndex = -1;
            listTemplateFiles.Focus();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (listTemplateFiles.SelectedIndex == -1)
            {
                MessageBox.Show("Not file selected!", "Select template file", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }
            ListBox.SelectedIndexCollection indexes = listTemplateFiles.SelectedIndices;
            m_pSelectedTemplateFiles = new string[indexes.Count];
            for (int i = 0; i < indexes.Count; i++)
            {
                m_pSelectedTemplateFiles[i] = Path.Combine(m_strDbFolder, listTemplateFiles.Items[i].ToString());
            }
            this.btnOK.DialogResult = DialogResult.OK;
            this.DialogResult = DialogResult.OK;
            this.Close();
        }
    }
}